<?php
//
// Automatisches Fotoalbum fr http://www.skriptweb.de
//
// (c) 2002 Christoph Moder cmoder@bigfoot.com, cm@skriptweb.de
// Dieses Programm unterliegt der GNU GPL, siehe http://www.gnu.org/copyleft/gpl.html
//
//
// Benutzung:
// ~~~~~~~~~
// In ein Verzeichnis dieses PHP-Skript sowie die Dateien head.html, tail.html 
// und fotozoom.php (samt zugehrigen Icons) kopieren.
// Dabei enthlt head.html den Kopf des Fotoalbums (mind. bis einschl. <BODY>-Tag),
// und tail.html den Fu des Fotoalbums (d.h. mindestens </BODY></HTML>).
// Achtung: der Webserver (der das PHP-Programm ausfhrt) muss Schreibrechte in
// diesem Verzeichnis haben (index.html wird angelegt).
//
// Des weiteren braucht man ein Unterverzeichnis PICTURES (dort sind die Bilder im
// JPEG-Format) und ein Unterverzeichnis PREVIEW (dort sind die Vorschaubilder, die
// den gleichen Dateinamen wie die hochauflsenden Bilder haben mssen).
// 
// Um eine Beschreibung im ALT-Tag (<IMG alt="...">) zu realisieren, schreibt man diesen
// Text in eine Datei mit dem selben Namen des Bildes (aber der Endung .txt) im
// PICTURES-Verzeichnis. Wenn keine Beschreibungsdatei vorhanden ist, wird nur die
// Dateigre (in kB) eingetragen (ansonsten wird die Gre hinter die Beschreibung eingetragen).
//
// Hochformatbilder werden automatisch erkannt und getrennt von den Querformatbildern
// (d.h. darunter) angeordnet (damit es besser aussieht). Vorschaubilder werden immer in
// 320x240 dargestellt, d.h. Querformat-Vorschaubilder werden so skaliert, dass ihre Hhe
// 240 Pixel betrgt, und Hochformat-Vorschaubilder so, dass ihre Hhe 320 Pixel betrgt.
//
// Wenn kein Vorschaubild vorhanden ist, wird das groe Bild genommen und entsprechend
// herunterskaliert (d.h. optisch kein Unterschied, aber es braucht viel lnger zum Laden).
//
// Der Default-Zoomfaktor fr die hochauflsenden Bilder wird so gewhlt, dass die Bilder
// ungefhr auf einen 800x600 Pixel groen Bildschirm (mit Browser) passen.
//
// Zusatzfeature:
// Wenn man mehrere Fotoalben hat, kann man sie ganz normal erstellen und in
// Unterverzeichnisse kopieren. Diesen Unterverzeichnissen gibt man beliebige,
// aussagekrftige Namen, und entfernt im Hauptprogramm die Kommentarzeichen /* und */.
// Dann wird in jedem Unterverzeichnis ein Fotoalbum generiert, und es wird im
// Wurzelverzeichnis (da, wo update.php ist) eine verlinkte Liste mit den Verzeichnissen
// angelegt.
// Beispiel: gibt es die Unterverzeichnisse "Mallorca 1999", "USA 2000" und
// "Schweden 2001" (jeweils mit fotozoom.php, PREVIEW-Verzeichnis, PICTURES-Verzeichnis,
// head.html, tail.html usw.), dann wird im Wurzelverzeichnis zustzlich eine HTML-Datei
// namens index.html erzeugt, die Links auf die drei Alben enthlt (die Links heien
// wie die Verzeichnisse) und aus head.html und tail.html (im Wurzelverzeichnis) besteht.
?>

<HTML>

<HEAD>
	<TITLE>Skriptweb - dynamisches Fotoalbum</TITLE>

	<META name="description" content="Skripten und Links f&uuml;r Physikstudenten">
	<META name="author" content="Christoph Moder">
	<META name="keywords" lang="de" content="Skript, Vorlesung, Mitschrift, Universit&auml;t, TU M&uuml;nchen, TUM, Physik, Mathematik">
	<META name="date" content="2002-01-02T12:27:00+00:00">		<!-- Wann wurde die Datei erzeugt? -->
	<META name="robots" content="follow">				<!-- Robots bitte indizieren, inklusive Links -->
	<META http-equiv="content-type" content="text/html; charset=iso-8859-1">
	<META http-equiv="expires" content="60">	<!-- nach einer Minute veraltet -->
	<META http-equiv="content-language" content="de">		<!-- deutsch als Sprache -->
	<META name="generator" content="per Hand und SelfHTML">		<!-- Mit welchem Werkzeug gemacht? -->
	<META name="revisit-after" content="30 days">			<!-- nach so langer Zeit soll der Robot das nchste Mal vorbeikommen -->

	<!-- siehe http://www.roads.lut.ac.uk/METAdata/DC-Qualifiers.html : -->
	<META name="DC.Title" content="index.html">			<!-- Dateiname -->
	<META name="DC.Creator" content="Christoph Moder">		<!-- Autor -->
	<META name="DC.Subject" content="Physik-Skripten">		<!-- Thema -->
	<META name="DC.Description" content="Skripten und Links f&uuml;r Physikstudenten">	<!-- Kurzbeschreibung -->
	<META name="DC.Publisher" content="Christoph Moder">		<!-- Herausgeber -->
	<META name="DC.Contributor" content="">				<!-- Co-Autoren, durch Kommata getrennt -->
	<META name="DC.Date" content="2000-06-15">			<!-- Datum der Publikation -->
	<META name="DC.Identifier" content="http://www.skriptweb.de/">	<!-- z.B. URL -->
	<META name="DC.Language" content="de">				<!-- Sprache -->
	<META name="DC.Rights" content="Alle Rechte liegen beim Autor">	<!-- Angaben zum Copyright -->

	<META http-equiv="Content-Style-Type" content="text/css">
	<LINK rel="stylesheet" type="text/css" href="../skriptweb.css">

	<BASE target="_top">
</HEAD>

<BODY bgcolor="#FFFFFF">

	<H1>Dynamisches Fotoalbum</H1>

<?php

// Arbeitet wie die Funktion fpassthru(), die den Inhalt einer offenen Datei (ab dem Dateizeiger) nach stdout schreibt;
// der Unterschied ist, dass hier nicht nach stdout, sondern die im Hauptprogramm geffnete Datei $output
function fpassthru_file( $inputfile )
{
	global $output;
	
	// Gre der Eingabedatei ermitteln
	$backup_fp = ftell( $inputfile );
	fseek( $inputfile, 0, SEEK_END );
	$max_inputsize = ftell( $inputfile );
	fseek( $inputfile, $backup_fp, SEEK_SET );

	// aus Eingabedatei lesen und in Ausgabedatei schreiben
	fwrite( $output, fread( $inputfile, $max_inputsize ) );

	// Eingabedatei schlieen (macht fpassthru() auch so)
	fclose( $inputfile );
}

function get_size_jpeg( $filename, &$height, &$width )
{
//FIXME!!! Warum funktioniert "or return 0" nicht?
	$jpegfile = fopen( $filename, "rb" ); // or return 0;
	//$currentdir = posix_getcwd();

	echo( "Untersuche die Gr&ouml;&szlig;e von $filename<BR>\n" );

	// JPEG-Header lesen und testen, ob die Signatur (erste zwei Bytes) stimmt
	$input = fread( $jpegfile, 2 );
	if( ! strstr( "ffd8", bin2hex( $input[0] . $input[1] ) ) )
	{
		echo( "keine JPEG-Datei!<BR>\n" );
		return -1;
	}

	while( ! feof( $jpegfile ) )
	{
		// Sub-Header lesen und schauen, ob es der richtige ist; wenn nicht: zum nchsten Subheader
		// immer 4 Bytes lesen (2 Bytes Subheader-ID, 2 Bytes Lnge des Subheaders)
		$input = fread( $jpegfile, 4 );
		
		if( ( 0 == strcmp( "ff", bin2hex( $input[0] ) ) ) && ( 0 != strcmp( "c0", bin2hex( $input[1] ) ) ) )
		{
			$subheader_size = hexdec( bin2hex( $input[2] . $input[3] ) );
			// 2 mssen abgezogen werden, da wir schon 4 Bytes vom Header gelesen haben (die ersten beiden zhlen nicht mit)
			echo( ($subheader_size - 2) . " weiter...\n<BR>" );
			fseek( $jpegfile, $subheader_size - 2, SEEK_CUR );
		}
		elseif( 0 == strcmp( "ffc0", bin2hex( $input[0] . $input[1] ) ) )
		{
			// jetzt lesen wir gleich weiter und lassen das erste Byte unter den Tisch fallen
			// in den nchsten beiden Words stehen Hhe und Breite des Bildes
			$input = fread( $jpegfile, 5 );
			$height = hexdec( bin2hex( $input[1] . $input[2] ) );
			$width = hexdec( bin2hex( $input[3] . $input[4] ) );
			
			echo( "Bildgr&ouml;&szlig;e ermittelt: " . $width . "x" . $height . " (Breite x H&ouml;he)<BR>\n" );
			fclose( $jpegfile );
			return 0;
		}
		
	}

	echo( "Bildgr&ouml;&szlig;e konnte nicht ermittelt werden!<BR>\n" );

	fclose( $jpegfile );

	return -1;
}

function output_description( $file )
{
	ereg( "(.+)(\..{3,4})", $file, $regs );		// Dateiname und Endung trennen
	$description = $regs[1] . ".txt";		// neue Endung .txt

	if( is_readable( $description ) )		// wenn diese Datei existiert:
	{
		$f_description = fopen( $description, "rb" );
		fpassthru_file( $f_description );	// ffnen und ausgeben
	}
}

function find_images()
{
	global $output;

	// Default-Werte fr Breite und Hhe; sie werden genommen, wenn aus den Bilddaten nichts ermittelt werden kann
	$width = 2048;
	$height = 1536;

	$pictures = array();		// ein leeres Array anlegen
	$vert_pictures = array();	// ein leeres Array anlegen

	chdir( "PICTURES" );		// hier sind die Bilder drinnen
	$handle = opendir( "." );	// Verzeichnis ffnen

	echo( "Gehe ins Verzeichnis PICTURES<BR>" );

	while( $file = readdir( $handle ) )	// nchsten Eintrag lesen, bis keiner mehr kommt
	{
		// Dateiname auftrennen
		// wenn es einen Punkt (davor mindestens ein anderes Zeichen) und dahinter 3 oder 4 Buchstaben gibt,
		// kommt das in $regs[2], alles davor in $regs[1]
		ereg( "(.+)(\..{3,4})", $file, $regs );
		
		// wenn es eine echte Datei ist
		if( ( ! is_dir( $file )) && ( $file != "." ) && ( $file != ".." ) && ( ".jpg" == strtolower( $regs[2] ) ) )
		{
			array_push( $pictures, $file );
			echo( "Datei gefunden: " . $file . " (" . filetype( $file ) . ") " . "<BR>" );
		}
	}

	closedir($handle);

	// weil die Dateien bei array_pop() in umgekehrter Reihenfolge geholt werden, sortieren wir es
	// jetzt in umgekehrter Reihenfolge, damit es dann wieder stimmt
	rsort( $pictures );

	fputs( $output, "\n\t<P>\n" );
	
	// jetzt werden die Bilder mit Links eingefgt
	while( $file = array_pop( $pictures ) )
	{
		// erstmal Ausmae des Bildes bestimmen
		get_size_jpeg( $file, $height, $width );
		
		// wenn es Hochformatbilder sind: jetzt noch nicht, die kommen spter dran
		if( $width < $height )
		{
			array_push( $vert_pictures, $file );
		}
		else
		{
			$anchor = rawurlencode( $file );
			$size = round( filesize( $file ) / 1024 );	// Dateigre in kB
			
			// ausgehend von 800x600 (abzglich Navigationsframe, d.h. Breite 600)
			// => Breite bestimmt bei Querformatbildern den Prozentsatz des Zoomfaktors
			$initial_zoomfactor = round( 100 * 600 / $width );

			// die Gre des Vorschaubildes richtet sich nach der Hhe:
			// alle Vorschaubilder bekommen die gleiche Hhe (240 Pixel),
			// die Breite wird dazu entsprechend angepasst
			// (aus Seitenverhltnis des Bildes)
			$preview_width = round( 240 * $width / $height );

			fputs( $output, "\t<A href=\"fotozoom.php?Filename=PICTURES%2F" . rawurlencode( $file ) . "&Factor=" . $initial_zoomfactor . "&initialWidth=" . $width . "&initialHeight=" . $height . "&Background=&BGColor=FFFFFF&FGColor=000000&BackToStart=index%2Ehtml%23" . $anchor . "\" name=\"" . $anchor . "\">\n" );

			if( is_readable( "../PREVIEW/$file" ) )		// wenn Vorschaubild vorhanden
			{
				fputs( $output, "\t\t<IMG src=\"PREVIEW/" . rawurlencode( $file ) . "\" width=\"" . $preview_width . "\" height=\"240\" vspace=\"10\" hspace=\"10\" border=\"0\" alt=\"[" );
			}
			else	// wenn kein Vorschaubild vorhanden: groes Bild nehmen, herunterskalieren
			{
				fputs( $output, "\t\t<IMG src=\"PICTURES/" . rawurlencode( $file ) . "\" width=\"" . $preview_width . "\" height=\"240\" vspace=\"10\" hspace=\"10\" border=\"0\" alt=\"[" );
			}

			output_description( $file );
			fputs( $output, " (" . $size . " kB)]\" title=\"[" );
			output_description( $file );
			fputs( $output, " (" . $size . " kB)]\">\n\t</A>\n\n" );

		}
	}

	fputs( $output, "\n\t</P>\n\n\t<P>\n" );

	// jetzt sind die Hochformat-Bilder dran (getrennt, damit es gleichmiger aussieht)
	while( $file = array_shift( $vert_pictures ) )	// holt die Elemente vom Array-Anfang, im Gegensatz zu array_pop()
	{
		// erstmal Ausmae des Bildes bestimmen
		get_size_jpeg( $file, $height, $width );
		
		$anchor = rawurlencode( $file );
		$size = round( filesize( $file ) / 1024 );	// Dateigre in kB
		
		// ausgehend von 800x600: davon ist ca. 3/4 der Hhe nutzbar (=450)
		// => Hhe bestimmt bei Hochformatbildern den Prozentsatz des Zoomfaktors
		$initial_zoomfactor = round( 100 * 450 / $height );
		
		// die Gre des Vorschaubildes richtet sich nach der Hhe:
		// alle Vorschaubilder bekommen die gleiche Hhe (320 Pixel),
		// die Breite wird dazu entsprechend angepasst
		// (aus Seitenverhltnis des Bildes)
		$preview_width = round( 320 * $width / $height );

		fputs( $output, "\t<A href=\"fotozoom.php?Filename=PICTURES%2F" . rawurlencode( $file ) . "&Factor=30&initialWidth=" . $width . "&initialHeight=" . $height . "&Background=&BGColor=FFFFFF&FGColor=000000&BackToStart=index%2Ehtml%23" . $anchor . "\" name=\"" . $anchor . "\">\n" );

		if( is_readable( "../PREVIEW/$file" ) )		// wenn Vorschaubild vorhanden
		{
			fputs( $output, "\t\t<IMG src=\"PREVIEW/" . rawurlencode( $file ) . "\" width=\"" . $preview_width . "\" height=\"320\" vspace=\"10\" hspace=\"10\" border=\"0\" alt=\"[" );
		}
		else	// wenn kein Vorschaubild vorhanden: groes Bild nehmen, herunterskalieren
		{
			fputs( $output, "\t\t<IMG src=\"PICTURES/" . rawurlencode( $file ) . "\" width=\"" . $preview_width . "\" height=\"320\" vspace=\"10\" hspace=\"10\" border=\"0\" alt=\"[" );
		}

		output_description( $file );
		fputs( $output, " (" . $size . " kB)]\" title=\"[" );
		output_description( $file );			
		fputs( $output, " (" . $size . " kB)]\">\n\t</A>\n\n" );
	}

	fputs( $output, "\n\t</P>\n" );
	
	chdir( ".." );
}

// HAUPTPROGRAMM

	// Ausgabedatei ffnen; Achtung, hierzu muss das Verzeichnis world-writeable sein!
	$output = fopen( "./index.html", "wb" ) or die( "Fehler: Konnte Ausgabedatei nicht &ouml;ffnen (index.html)." );
	echo( "<P>Ausgabedatei ge&ouml;ffnet (index.html)</P>" );
	
	// zuerst Seitenanfang ausgeben
	$file = fopen( "./head.html", "rb" ) or die( "Fehler: Konnte Kopfdatei nicht &ouml;ffnen (head.html)." );
	fpassthru_file( $file );
	echo( "Kopf geschrieben (aus head.html)<BR>" );

	// FR MEHRERE FOTOGALERIEVERZEICHNISSE: bitte die folgenden mit /*...*/ auskommentierten Blcke aktivieren
/*
	$handle = opendir( "." );		// Verzeichnis ffnen

	fputs( $output, "\n\t<UL>\n" );

	while( $fotodir = readdir( $handle ) )	// nchsten Eintrag lesen, bis keiner mehr kommt
	{
		// wenn es ein Verzeichnis ist
		if( is_dir( $fotodir ) && ( $fotodir != "." ) && ( $fotodir != ".." ) )
		{
			chdir( $fotodir );	// in das gefundene Verzeichnis gehen

			$save_output = $output;	// Dateihandle sichern
			// neue Ausgabedatei ffnen, mit gleichem Handle; Achtung, hierzu muss das Verzeichnis world-writeable sein!
			$output = fopen( "index.html", "wb" ) or die( "Fehler: Konnte Ausgabedatei nicht &ouml;ffnen ($fotodir/index.html)." );

			// zuerst Seitenanfang ausgeben
			$file = fopen( "head.html", "rb" ) or die( "Fehler: Konnte Kopfdatei nicht &ouml;ffnen ($fotodir/head.html)." );
			fpassthru_file( $file );
*/

	// Dann durch die Verzeichnishierarchie gehen
	find_images();
/*
			// zum Schluss Seitenende ausgeben
			$file = fopen( "tail.html", "rb" ) or die( "Fehler: Konnte Enddatei nicht &ouml;ffnen ($fotodir/tail.html)" );
			fpassthru_file( $file );

			fclose( $output );
			$output = $save_output;	// Dateihandle zurcksichern
			chdir( ".." );		// wieder zurck ins Wurzelverzeichnis der Galerie

			// jetzt der Eintrag in die Index-Datei
			fputs( $output, "\n\t\t<LI><A href=\"" . rawurlencode( $fotodir ) . "\">" . htmlentities( $fotodir ) . "</A></LI>\n" );
		}
	}

	fputs( $output, "\n\t</UL>\n" );
*/
	// ENDE DES CODES FR MEHRERE FOTOGALERIEVERZEICHNISSE
	
	// zum Schluss Seitenende ausgeben
	$file = fopen( "./tail.html", "rb" ) or die( "Fehler: Konnte Enddatei nicht &ouml;ffnen (tail.html)" );
	fpassthru_file( $file );
	echo( "Ende geschrieben (aus tail.html)<BR>" );

	fclose( $output );
?>

	<P></P><P></P>
	Fertig!<BR>
	<A href="index.html" target="_blank">Neu generierte Seite</A> (erzeugt: <?php echo( date( "d.m.Y  H:i:s" ) ); ?>).

	<HR>
	<SMALL>&copy; 2002 Christoph Moder</SMALL>

</BODY>
</HTML>
